//***********************************************************************
//***********************************************************************
//****																*****
//**** 		Globale Symboldefinitionen fr Magnetmesssystem			*****
//****																*****
//***********************************************************************
//***********************************************************************

//***********************************************************************
//****			
//**** 				I/Os
//****							
//***********************************************************************

#bit CSN=LatA.0						// Chip Select
#bit SCLK=LatA.1					// Taktsignal
#bit SDI=PortA.2					// Daten
// #bit INDEX=PortB.0				// Index-Signal alle 2mm --> Interrupt
#bit POWER=LatA.3					// Power LED
#bit RS485_TXEN=LatB.3

//***********************************************************************
//****	
//**** 				Initialisierungswerte fr Periferie	
//****									
//***********************************************************************

#define OSCON_Config 0b11110000		// Idle Mode enabled, 8 MHz, System Clock= primary Oszilator

#define T0_ON_Config 0b10000001		// On, 16-Bit interner Takt 1:4

#define IntCon_Config 0b11100000	// Global, TMR0 und Peripherie enabled
//#define IntCon_Config 0b01110000	// disabled
#define InTCon2_Config 0b00000000	// Pull Ups Enabled, alles Low-Priority
#define IntCon3_Config 0b00000000	// alles Low Priority
#define PIE1_Config 0b00100000		// RCIE Enabled;
#define IPR1_Config 0b00000000		// Peripherie Interrupts alle Low Priority
#define IPR2_Config 0b00000000		// Peripherie Interrupts alle Low Priority

#define TrisA_Config 0b00000100		// SDI Eingang
#define TrisB_Config 0b00010000		// RXD Eingang

#define PortA_Init 0b11111111
#define PortB_Init 0b11110111

// AD / Comparatorkonfiguration
#define ADCON0_Config 0b00000000	// AD Off
#define ADCON1_Config 0b11111111	// alles digitale IO

// Serielle Schnittstelle
#define RCSTA_Config 0b11110000		// Serial Port enabled, 9 Bit, Empfang enabled
#define TXSTA_Config 0b01100100		// BRGH=0, Usart High Speed
#define BAUDCTL_Config 0b00000000
#define SPBRG_Config 12				// 38.400Baud

//***********************************************************************
//****							
//**** 							Konstanten	
//****		
//***********************************************************************

#define TMR0StartValue 0xFFFF-500+12  	// Zeitkonstante fr TMR0 Interupt (alle 10ms)
#define EBuffSize1 20					// Empfangspuffergre
#define SBuffSize1 20					// Sendepuffergre
#define MaxRS232_1Timeout 10			// maximale Zeit (*10ms) zwischen zwei Bytes

//***********************************************************************
//****				
//**** 						Globale Variablen	
//****				
//***********************************************************************

// Com1 (UART)
int PSBuff1=0;							// aktuelle Sendepufferposition
int PEBuff1=0;							// aktuelle Empfangspufferposition
int SBuff1[SBuffSize1];					// Sendepuffer
int Ebuff1[EBuffSize1];					// Empfangspuffer
int ZSend1=0;							// Anzahl zu sendender Bytes
int SysAdr=0;							// Systemadresse fr RS485
short _EmpfangAktiv=false;				// momentaner Datenempfang ber RS232
short _DatenEmpfangen=false;			// Datensatz komplett empfangen
int RS232_1Timeout=0;					// Timeout bei Datenempfang
short _TimeToRead5311=false;			// alle Xms AS5311 auslesen


struct B32 
{ 
   char B0:8, B1:8, B2:8, B3:8;
};

union BI32
{
   signed int32 I32;
   struct B32 Bytes;
};

union BI32 Messwert;					// letzter Absolutmesswert
signed int32 PosT1=0;					// Position in 2/4096 er Schritten ohne aktuellen Messwert
int16 AS5311Value=0;					// letzter Messwert vom AS5311
int16 MWOffset=0;						// Messwert an Position 0

int AS5311Flags;
#bit Flag_SDOK=AS5311Flags.5			// serieller Datenstrom vom AS5311 OK
#bit Flag_OCF=AS5311Flags.4
#bit Flag_COF=AS5311Flags.3
#bit Flag_LIN=AS5311Flags.2
#Bit Flag_MagInc=AS5311Flags.1
#bit Flag_MagDec=AS5311Flags.0

//***********************************************************************
//****							
//**** 							sonstiges	
//****				
//***********************************************************************

#define DoNop #asm nop #endasm